#version 120

// Fragment shader for cartoon rendering type effects
//
// Author: Jeff Brown
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;
uniform int mode;

uniform vec4 textureRect;

varying vec2 gUV;
uniform float randomValue;
uniform float colorLevels;
uniform float saturation;


float coeffs_fx[9] = float[](-1.0, 0.0, 1.0,-2.0, 0.0, 2.0,-1.0, 0.0, 1.0);

uniform float coeffs_fy[9] = float[9](+1.0f, +2.0f, +1.0f,
                                      +0.0f, +0.0f, +0.0f,
                                      -1.0f, -2.0f, -1.0f);

uniform vec2 offset[9] = vec2[9](vec2(-1.0f, +1.0f), vec2(+0.0f, +1.0f), vec2(+1.0f, +1.0f),
                                 vec2(-1.0f, +0.0f), vec2(+0.0f, +0.0f), vec2(+1.0f, +0.0f),
                                 vec2(-1.0f, -1.0f), vec2(+0.0f, -1.0f), vec2(+1.0f, -1.0f));



vec3 RGBtoHSV(float r, float g, float b) {
    
    float K = 0.0;
    float tmp;
    
    if (g < b)
    {
        tmp = g;
        g=b;
        b=tmp;
        
        K = -1.0;
    }
    
    if (r < g)
    {
        tmp = r;
        r=g;
        g=tmp;
        
        K = -2.9 / 6.9 - K;
    }
    
    float chroma = r - min(g, b);
    
    float h = abs(K + (g - b) / (6.0 * chroma + 1e-20));
    float s = chroma / (r + 1e-20);
    float v = r;
    
    return vec3(h, s, v);
}

vec3 HSVtoRGB(float h,float s,float v) { return mix(vec3(1.),clamp((abs(fract(h+vec3(3.,2.,1.)/3.)*6.-3.)-1.),0.,1.),s)*v; }


void main(void)
{
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else
    {
        float y = 0.0f, gx = 0.0f, gy = 0.0f;
        vec2 pos;
        vec2 current = gUV;
        vec4 color=vec4(0.,0.,0.,0.);
        for (int i = 0; i < offset.length(); i++)
        {
            pos.x = current.x+offset[i].x;
            pos.y = current.y+offset[i].y;
            vec4 tmpColor = texture2DRect(texUnit, pos);
            color+=tmpColor;
            y=(tmpColor.r+tmpColor.g+tmpColor.b)*.3333;
            gx += (y*coeffs_fx[i]);
            gy += (y*coeffs_fy[i]);
        }
        float isEdge = sqrt((gx*gx)+(gy*gy));
        isEdge*=3.0;
        isEdge-=fract(isEdge);
        isEdge*=3.0;
        
        color*=0.11111111;
        
        
        vec3 vHSV =  RGBtoHSV(color.r,color.g,color.b);

        float tmp;
        tmp=vHSV.x*(12.0*colorLevels);
        tmp-=fract(tmp);
        vHSV.x=tmp/(12.0*colorLevels);
        
        tmp=vHSV.y*(6.0*colorLevels);
        tmp-=fract(tmp);
        vHSV.y=tmp/(6.0*colorLevels);
        vHSV.y*=saturation;

        tmp=vHSV.z*(5.0*colorLevels);
        tmp-=fract(tmp);
        vHSV.z=tmp/(5.0*colorLevels);

        
        vec3 vRGB = mix(HSVtoRGB(vHSV.x,vHSV.y,vHSV.z),vec3(0.0,0.0,0.0),isEdge);
        gl_FragColor = vec4(min(1.0,vRGB.x),min(1.0,vRGB.y),min(1.0,vRGB.z),texture2DRect(texUnit, gUV).a);
    }
}
